define("core_courseformat/local/content/actions/bulkselection",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.toggleBulkSelectionAction=_exports.switchBulkSelection=_exports.selectAllBulk=_exports.checkAllBulkSelected=void 0;
/**
   * Bulk selection auxiliar methods.
   *
   * @module     core_courseformat/local/content/actions/bulkselection
   * @class      core_courseformat/local/content/actions/bulkselection
   * @copyright  2023 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class BulkSelector{constructor(courseEditor){this.courseEditor=courseEditor,this.selectors={BULKCMCHECKBOX:"[data-bulkcheckbox][data-action='toggleSelectionCm']",BULKSECTIONCHECKBOX:"[data-bulkcheckbox][data-action='toggleSelectionSection']",CONTENT:"#region-main"}}processNewSelection(id,elementType,settings){const value=!this._isBulkSelected(id,elementType);settings.all&&settings.range?this.switchCurrentSelection():this._isSelectable(id,elementType)&&(settings.all?"cm"==elementType?this._updateBulkCmSiblings(id,value):this._updateBulkSelectionAll(elementType,value):settings.range?this._updateBulkSelectionRange(id,elementType,value):this._updateBulkSelection([id],elementType,value))}switchCurrentSelection(){const bulk=this.courseEditor.get("bulk");if(""===bulk.selectedType||0==bulk.selection.length)return;const newSelectedType="section"===bulk.selectedType?"cm":"section";let newSelectedIds;newSelectedIds="section"===bulk.selectedType?this._getCmIdsFromSections(bulk.selection):this._getSectionIdsFromCms(bulk.selection);const affectedIds=[];newSelectedIds.forEach((newId=>{this._getSelector(newId,newSelectedType)&&affectedIds.push(newId)})),this.courseEditor.dispatch("bulkEnable",!0),0!=affectedIds.length&&this._updateBulkSelection(affectedIds,newSelectedType,!0)}selectAll(value){const bulk=this.courseEditor.get("bulk");if(""==bulk.selectedType)return;if(!value)return void this.courseEditor.dispatch("bulkEnable",!0);const elementType=bulk.selectedType;this._updateBulkSelectionAll(elementType,value)}checkAllSelected(){const bulk=this.courseEditor.get("bulk");return""!=bulk.selectedType&&this._getContentCheckboxes(bulk.selectedType).every((bulkSelect=>{if(bulkSelect.disabled)return!0;if("section"==bulk.selectedType){if(!this.courseEditor.get("section",bulkSelect.dataset.id).bulkeditable)return!0}return bulk.selection.includes(bulkSelect.dataset.id)}))}_isBulkSelected(id,elementType){const bulk=this.courseEditor.get("bulk");return bulk.selectedType===elementType&&bulk.selection.includes(id)}_updateBulkSelection(ids,elementType,value){let mutation=elementType;mutation+=value?"Select":"Unselect",this.courseEditor.dispatch(mutation,ids)}_getContentCheckboxes(elementType){const selector="cm"==elementType?this.selectors.BULKCMCHECKBOX:this.selectors.BULKSECTIONCHECKBOX;return[...document.querySelectorAll("".concat(this.selectors.CONTENT," ").concat(selector))]}_isSelectable(id,elementType){const bulkSelect=this._getSelector(id,elementType);return!(!bulkSelect||bulkSelect.disabled)}_getSelector(id,elementType){let selector="cm"==elementType?this.selectors.BULKCMCHECKBOX:this.selectors.BULKSECTIONCHECKBOX;return selector+="[data-id='".concat(id,"']"),document.querySelector("".concat(this.selectors.CONTENT," ").concat(selector))}_updateBulkSelectionRange(id,elementType,value){const bulk=this.courseEditor.get("bulk");let lastSelectedId=bulk.selection.at(-1);if(bulk.selectedType!==elementType||lastSelectedId==id)return void this._updateBulkSelection([id],elementType,value);const affectedIds=[];let found=0;this._getContentCheckboxes(elementType).every((bulkSelect=>{if(bulkSelect.disabled)return!0;if("section"==elementType){const section=this.courseEditor.get("section",bulkSelect.dataset.id);if(value&&(null==section||!section.bulkeditable))return!0}return bulkSelect.dataset.id!=id&&bulkSelect.dataset.id!=lastSelectedId||found++,0==found||(affectedIds.push(bulkSelect.dataset.id),2!=found)})),this._updateBulkSelection(affectedIds,elementType,value)}_updateBulkCmSiblings(cmId,value){if("section"===this.courseEditor.get("bulk").selectedType)return;const cm=this.courseEditor.get("cm",cmId),section=this.courseEditor.get("section",cm.sectionid),affectedIds=[];section.cmlist.forEach((sectionCmId=>{this._isSelectable(sectionCmId,"cm")&&affectedIds.push(sectionCmId)})),this._updateBulkSelection(affectedIds,"cm",value)}_updateBulkSelectionAll(elementType,value){const affectedIds=[];this._getContentCheckboxes(elementType).forEach((bulkSelect=>{if(!bulkSelect.disabled){if("section"==elementType){const section=this.courseEditor.get("section",bulkSelect.dataset.id);if(value&&(null==section||!section.bulkeditable))return}affectedIds.push(bulkSelect.dataset.id)}})),this._updateBulkSelection(affectedIds,elementType,value)}_getCmIdsFromSections(sectionIds){const result=[];return sectionIds.forEach((sectionId=>{const section=this.courseEditor.get("section",sectionId);result.push(...section.cmlist)})),result}_getSectionIdsFromCms(cmIds){const result=new Set;return cmIds.forEach((cmId=>{const cm=this.courseEditor.get("cm",cmId);0!=cm.sectionnumber&&result.add(cm.sectionid)})),[...result]}}_exports.toggleBulkSelectionAction=function(courseEditor,target,event,elementType){const id=target.dataset.id;if(!id)return;target.dataset.preventDefault&&event.preventDefault(),document.getSelection().removeAllRanges();new BulkSelector(courseEditor).processNewSelection(id,elementType,{range:event.shiftKey,all:event.altKey})};_exports.switchBulkSelection=function(courseEditor){new BulkSelector(courseEditor).switchCurrentSelection()};_exports.selectAllBulk=function(courseEditor,value){new BulkSelector(courseEditor).selectAll(value)};_exports.checkAllBulkSelected=function(courseEditor){return new BulkSelector(courseEditor).checkAllSelected()}}));

//# sourceMappingURL=bulkselection.min.js.map