define("core/local/action_menu/subpanel",["exports","core/utils","core/pagehelpers","core/pending","core/aria","theme_boost/bootstrap/dom/event-handler"],(function(_exports,_utils,_pagehelpers,_pending,_aria,_eventHandler){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Action menu subpanel JS controls.
   *
   * @module      core/local/action_menu/subpanel
   * @copyright   2023 Mikel Martín <mikel@moodle.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_pending=_interopRequireDefault(_pending),_eventHandler=_interopRequireDefault(_eventHandler);const Selectors_mainMenu='[role="menu"]',Selectors_dropdownRight=".dropdown-menu-end",Selectors_subPanel=".dropdown-subpanel",Selectors_subPanelMenuItem=".dropdown-subpanel > .dropdown-item",Selectors_subPanelContent=".dropdown-subpanel > .dropdown-menu",Selectors_drawer='[data-region="fixed-drawer"]',Selectors_blockColumn=".blockcolumn",Selectors_columnLeft=".columnleft",Classes_dropRight="dropend",Classes_dropLeft="dropstart",Classes_dropDown="dropdown",Classes_forceLeft="downleft",Classes_contentDisplayed="content-displayed",BootstrapEvents_hideDropdown="hidden.bs.dropdown";let initialized=!1;const updateAllPanelsPosition=()=>{document.querySelectorAll(Selectors_subPanel).forEach((dropdown=>{new SubPanel(dropdown).updatePosition()}))};class SubPanel{constructor(element){this.element=element,this.menuItem=element.querySelector(Selectors_subPanelMenuItem),this.panelContent=element.querySelector(Selectors_subPanelContent),this.showPreviewOnFocus=!0}init(){if(this.element.dataset.subPanelInitialized)return;this.updatePosition(),this.element.addEventListener("focusin",this._mainElementFocusInHandler.bind(this)),this.menuItem.addEventListener("click",this._menuItemClickHandler.bind(this));const subpanelMenuItemSelector="#".concat(this.element.id).concat(Selectors_subPanelMenuItem);_eventHandler.default.on(document,"keydown",subpanelMenuItemSelector,this._menuItemKeyHandler.bind(this)),(0,_pagehelpers.isBehatSite)()||(this.menuItem.addEventListener("mouseover",this._menuItemHoverHandler.bind(this)),this.menuItem.addEventListener("mouseout",this._menuItemHoverOutHandler.bind(this))),this.panelContent.addEventListener("keydown",this._panelContentKeyHandler.bind(this)),this.element.dataset.subPanelInitialized=!0}_hideCurrentSubPanel(event){const related=event.relatedTarget;this.menuItem.contains(related)||this.panelContent.contains(related)||this.setVisibility(!1)}_needSmallSpaceBehaviour(){return(0,_pagehelpers.isExtraSmall)()||null!==this.element.closest(Selectors_drawer)||null!==this.element.closest(Selectors_blockColumn)}_needDropdownRight(){return null===this.element.closest(Selectors_columnLeft)&&null!==this.element.closest(Selectors_dropdownRight)}_mainElementFocusInHandler(){!this._needSmallSpaceBehaviour()&&this.showPreviewOnFocus?this.setVisibility(!0):this.showPreviewOnFocus=!0}_menuItemClickHandler(event){event.stopPropagation(),event.preventDefault(),this._needSmallSpaceBehaviour()&&this.setVisibility(!this.getVisibility())}_menuItemHoverHandler(){this._needSmallSpaceBehaviour()||this.setVisibility(!0)}_menuItemHoverOutHandler(event){this._needSmallSpaceBehaviour()||(this._hideOtherSubPanels(),this._hideCurrentSubPanel(event))}_menuItemKeyHandler(event){if("ArrowUp"===event.key||"ArrowDown"===event.key&&!this._needSmallSpaceBehaviour())return void this.setVisibility(!1);let focusPanel=!1;("ArrowRight"===event.key||"ArrowLeft"===event.key||"Tab"===event.key&&!event.shiftKey)&&(focusPanel=!0),"Enter"!==event.key&&" "!==event.key||(focusPanel=!0),"ArrowDown"===event.key&&this._needSmallSpaceBehaviour()&&this.getVisibility()&&(focusPanel=!0),focusPanel&&(event.stopPropagation(),event.preventDefault(),this.setVisibility(!0),this._focusPanelContent())}_panelContentKeyHandler(event){const canLoop=!this._needSmallSpaceBehaviour();let isBrowsingSubPanel=!1,newFocus=null;"ArrowRight"!==event.key&&"ArrowLeft"!==event.key||(newFocus=this.menuItem),("Escape"===event.key||"Tab"===event.key&&event.shiftKey)&&(newFocus=this.menuItem,this.setVisibility(!1),this.showPreviewOnFocus=!1),"ArrowUp"===event.key&&(newFocus=(0,_pagehelpers.previousFocusableElement)(this.panelContent,canLoop),isBrowsingSubPanel=!0),"ArrowDown"===event.key&&(newFocus=(0,_pagehelpers.nextFocusableElement)(this.panelContent,canLoop),isBrowsingSubPanel=!0),"Home"===event.key&&(newFocus=(0,_pagehelpers.firstFocusableElement)(this.panelContent),isBrowsingSubPanel=!0),"End"===event.key&&(newFocus=(0,_pagehelpers.lastFocusableElement)(this.panelContent),isBrowsingSubPanel=!0),null===newFocus&&isBrowsingSubPanel&&!canLoop&&(newFocus=this.menuItem),null!==newFocus&&(event.stopPropagation(),event.preventDefault(),newFocus.focus())}_focusPanelContent(){const pendingPromise=new _pending.default("core/action_menu/subpanel:focuscontent");setTimeout((()=>{const firstFocusable=(0,_pagehelpers.firstFocusableElement)(this.panelContent);firstFocusable&&firstFocusable.focus(),pendingPromise.resolve()}),100)}setVisibility(visible){visible&&this._hideOtherSubPanels(),!visible&&this.getVisibility&&(0,_aria.hide)(this.panelContent),visible&&!this.getVisibility&&(0,_aria.unhide)(this.panelContent),this.menuItem.setAttribute("aria-expanded",visible?"true":"false"),this.panelContent.classList.toggle("show",visible),this.element.classList.toggle(Classes_contentDisplayed,visible)}_hideOtherSubPanels(){this.element.closest(Selectors_mainMenu).querySelectorAll("".concat(Selectors_subPanelContent,".show")).forEach((visibleSubPanel=>{const dropdownSubPanel=visibleSubPanel.closest(Selectors_subPanel);if(dropdownSubPanel===this.element)return;new SubPanel(dropdownSubPanel).setVisibility(!1)}))}getVisibility(){return"true"===this.menuItem.getAttribute("aria-expanded")}updatePosition(){const dropdownRight=this._needDropdownRight();if(this._needSmallSpaceBehaviour())return this.element.classList.remove(Classes_dropRight),this.element.classList.remove(Classes_dropLeft),this.element.classList.add(Classes_dropDown),void this.element.classList.toggle(Classes_forceLeft,dropdownRight);this.element.classList.remove(Classes_dropDown),this.element.classList.remove(Classes_forceLeft),this.element.classList.toggle(Classes_dropRight,!dropdownRight),this.element.classList.toggle(Classes_dropLeft,dropdownRight)}}_exports.init=selector=>{initialized||(document.addEventListener(BootstrapEvents_hideDropdown,(()=>{document.querySelectorAll("".concat(Selectors_subPanelContent,".show")).forEach((visibleSubPanel=>{const dropdownSubPanel=visibleSubPanel.closest(Selectors_subPanel);new SubPanel(dropdownSubPanel).setVisibility(!1)}))})),window.addEventListener("resize",(0,_utils.debounce)(updateAllPanelsPosition,400)),initialized=!0);const subMenu=document.querySelector(selector);if(!subMenu)throw new Error("Sub panel element not found: ".concat(selector));new SubPanel(subMenu).init()}}));

//# sourceMappingURL=subpanel.min.js.map